/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class KairiTheSwirlingSkyEffect
extends OneShotEffect {
    KairiTheSwirlingSkyEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "mill six cards, then return up to two instant and/or sorcery cards from your graveyard to your hand";
    }

    private KairiTheSwirlingSkyEffect(KairiTheSwirlingSkyEffect effect) {
        super((OneShotEffect)effect);
    }

    public KairiTheSwirlingSkyEffect copy() {
        return new KairiTheSwirlingSkyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.millCards(6, source, game);
        TargetCardInGraveyard target = new TargetCardInGraveyard(0, 2, (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
        target.withNotTarget(true);
        player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
        return player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
    }
}

