/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.game.Game;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class KairiTheSwirlingSkyTarget
extends TargetPermanent {
    private static final FilterPermanent filterStatic = new FilterNonlandPermanent("nonland permanents with total mana value 6 or less");

    KairiTheSwirlingSkyTarget() {
        super(0, Integer.MAX_VALUE, filterStatic, false);
    }

    private KairiTheSwirlingSkyTarget(KairiTheSwirlingSkyTarget target) {
        super((TargetPermanent)target);
    }

    public KairiTheSwirlingSkyTarget copy() {
        return new KairiTheSwirlingSkyTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        return super.canTarget(playerId, id, source, game) && CardUtil.checkCanTargetTotalValueLimit((Collection)this.getTargets(), (UUID)id, MageObject::getManaValue, (int)6, (Game)game);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        return CardUtil.checkPossibleTargetsTotalValueLimit((Collection)this.getTargets(), (Set)super.possibleTargets(sourceControllerId, source, game), MageObject::getManaValue, (int)6, (Game)game);
    }

    public String getMessage(Game game) {
        int selectedValue = this.getTargets().stream().map(arg_0 -> ((Game)game).getObject(arg_0)).filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
        return super.getMessage(game) + " (selected total mana value " + selectedValue + ")";
    }
}

