/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.List;
import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.constants.CardType;
import mage.filter.FilterSpell;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.SpellsCastWatcher;

class KalamaxTheStormsireSpellCastAbility
extends SpellCastControllerTriggeredAbility {
    private static final FilterSpell filterInstant = new FilterSpell();

    KalamaxTheStormsireSpellCastAbility() {
        super((Effect)new CopyTargetStackObjectEffect(true), filterInstant, false);
    }

    private KalamaxTheStormsireSpellCastAbility(KalamaxTheStormsireSpellCastAbility ability) {
        super((SpellCastControllerTriggeredAbility)ability);
    }

    public KalamaxTheStormsireSpellCastAbility copy() {
        return new KalamaxTheStormsireSpellCastAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        List spells;
        SpellsCastWatcher watcher;
        if (super.checkTrigger(event, game) && (watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class)) != null && (spells = watcher.getSpellsCastThisTurn(event.getPlayerId())) != null && spells.stream().filter(spell1 -> spell1.isInstant(game)).count() == 1L && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.isInstant(game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            }
            return true;
        }
        return false;
    }

    public boolean checkInterveningIfClause(Game game) {
        Permanent permanent = game.getPermanent(this.getSourceId());
        return permanent != null && permanent.isTapped();
    }

    public String getRule() {
        return "Whenever you cast your first instant spell each turn, if {this} is tapped, copy that spell. You may choose new targets for the copy.";
    }

    static {
        filterInstant.add((Predicate)CardType.INSTANT.getPredicate());
    }
}

