/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.BearToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class KamahlsSummonsEffect
extends OneShotEffect {
    KamahlsSummonsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player may reveal any number of creature cards from their hand. Then each player creates a 2/2 green Bear creature token for each card they revealed this way";
    }

    private KamahlsSummonsEffect(KamahlsSummonsEffect effect) {
        super((OneShotEffect)effect);
    }

    public KamahlsSummonsEffect copy() {
        return new KamahlsSummonsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            HashMap<UUID, Integer> revealedCards = new HashMap<UUID, Integer>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                TargetCardInHand target;
                Player player = game.getPlayer(playerId);
                if (player == null || player.getHand().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) <= 0 || !player.choose(this.outcome, (Target)(target = new TargetCardInHand(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_CREATURE)), source, game)) continue;
                CardsImpl cards = new CardsImpl((Collection)target.getTargets());
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                revealedCards.put(playerId, target.getTargets().size());
            }
            BearToken token = new BearToken();
            for (Map.Entry revealedCardsByPlayer : revealedCards.entrySet()) {
                int value = (Integer)revealedCardsByPlayer.getValue();
                if (value <= 0) continue;
                token.putOntoBattlefield(value, game, source, (UUID)revealedCardsByPlayer.getKey());
            }
            return true;
        }
        return false;
    }
}

