/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RemoveCountersSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactOrEnchantmentPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.target.Target;
import mage.target.TargetPermanent;

class KappaTechWreckerEffect
extends OneShotEffect {
    KappaTechWreckerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may remove a deathtouch counter from it. When you do, exile target artifact or enchantment that player controls";
    }

    private KappaTechWreckerEffect(KappaTechWreckerEffect effect) {
        super((OneShotEffect)effect);
    }

    public KappaTechWreckerEffect copy() {
        return new KappaTechWreckerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterArtifactOrEnchantmentPermanent filter = new FilterArtifactOrEnchantmentPermanent("artifact or enchantment that player controls");
        filter.add((Predicate)new ControllerIdPredicate(this.getTargetPointer().getFirst(game, source)));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ExileTargetEffect(), false);
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        return new DoWhenCostPaid(ability, (Cost)new RemoveCountersSourceCost(CounterType.DEATHTOUCH.createInstance()), "Remove a deathtouch counter?").apply(game, source);
    }
}

