/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.predicate.permanent.EnchantmentOrEnchantedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KarametrasBlessingEffect
extends OneShotEffect {
    KarametrasBlessingEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's an enchanted creature or enchantment creature, it also gains hexproof and indestructible until end of turn.";
    }

    private KarametrasBlessingEffect(KarametrasBlessingEffect effect) {
        super((OneShotEffect)effect);
    }

    public KarametrasBlessingEffect copy() {
        return new KarametrasBlessingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null || !EnchantmentOrEnchantedPredicate.instance.apply(permanent, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)HexproofAbility.getInstance(), Duration.EndOfTurn), source);
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn), source);
        return true;
    }
}

