/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetadjustment.DefineByTriggerTargetAdjuster;
import mage.target.targetadjustment.TargetAdjuster;

class KarmicJusticeTriggeredAbility
extends TriggeredAbilityImpl {
    KarmicJusticeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DestroyTargetEffect(), true);
        this.setLeavesTheBattlefieldTrigger(true);
        this.setTargetAdjuster((TargetAdjuster)DefineByTriggerTargetAdjuster.instance);
    }

    private KarmicJusticeTriggeredAbility(KarmicJusticeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public KarmicJusticeTriggeredAbility copy() {
        return new KarmicJusticeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DESTROYED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        MageObject mageObject;
        if (event.getPlayerId().equals(this.controllerId) && game.getOpponents(this.getControllerId()).contains(game.getControllerId(event.getSourceId())) && !(mageObject = game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)).isCreature(game)) {
            this.getTargets().clear();
            FilterPermanent filter = new FilterPermanent("target permanent that opponent controls");
            filter.add((Predicate)new ControllerIdPredicate(game.getControllerId(event.getSourceId())));
            TargetPermanent target = new TargetPermanent(filter);
            this.getTargets().add((Target)target);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a spell or ability an opponent controls destroys a noncreature permanent you control, you may destroy target permanent that opponent controls.";
    }
}

