/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentImpl;
import mage.players.Player;
import mage.util.CardUtil;

class KarnLiberatedDelayedEffect
extends OneShotEffect {
    private final UUID exileId;

    public KarnLiberatedDelayedEffect(UUID exileId) {
        super(Outcome.PlayForFree);
        this.exileId = exileId;
        this.staticText = "Put those cards onto the battlefield under your control";
    }

    private KarnLiberatedDelayedEffect(KarnLiberatedDelayedEffect effect) {
        super((OneShotEffect)effect);
        this.exileId = effect.exileId;
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ExileZone exileZone = game.getExile().getExileZone(this.exileId);
        if (controller == null || exileZone == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)exileZone);
        if (cards.isEmpty()) {
            return false;
        }
        controller.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        for (Card card : cards.getCards(game)) {
            Permanent permanent;
            if (card == null || (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) == null) continue;
            ((PermanentImpl)permanent).removeSummoningSickness();
        }
        return true;
    }

    public KarnLiberatedDelayedEffect copy() {
        return new KarnLiberatedDelayedEffect(this);
    }
}

