/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;

class KarnMinus1Effect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("card you own with a silver counter on it in exile");

    KarnMinus1Effect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Put a card you own with a silver counter on it from exile into your hand";
    }

    private KarnMinus1Effect(KarnMinus1Effect effect) {
        super((OneShotEffect)effect);
    }

    public KarnMinus1Effect copy() {
        return new KarnMinus1Effect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(game.getExile().getCardsOwned(filter, controller.getId(), source, game));
        switch (cards.size()) {
            case 0: {
                return false;
            }
            case 1: {
                card = cards.getRandom(game);
                break;
            }
            default: {
                TargetCardInExile target = new TargetCardInExile(filter);
                target.withNotTarget(true);
                controller.choose(this.outcome, (Target)target, source, game);
                card = cards.get(target.getFirstTarget(), game);
            }
        }
        if (card == null) {
            return false;
        }
        return controller.moveCards(card, Zone.HAND, source, game);
    }

    static {
        filter.add((Predicate)CounterType.SILVER.getPredicate());
    }
}

