/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class KarplusanStriderEffect
extends ContinuousRuleModifyingEffectImpl {
    KarplusanStriderEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "{this} can't be the target of blue or black spells";
    }

    private KarplusanStriderEffect(KarplusanStriderEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public KarplusanStriderEffect copy() {
        return new KarplusanStriderEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            return sourcePermanent.getLogName() + " can't be the target of blue or black spells";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGET;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getSourceId())) {
            Permanent targettedPermanent = game.getPermanent(event.getTargetId());
            Spell sourceSpell = game.getStack().getSpell(event.getSourceId());
            if (targettedPermanent != null && sourceSpell != null) {
                return sourceSpell.getColor(game).isBlue() || sourceSpell.getColor(game).isBlack();
            }
        }
        return false;
    }
}

