/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KasminaEnigmaSageGainAbilitiesEffect
extends ContinuousEffectImpl {
    KasminaEnigmaSageGainAbilitiesEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "each other planeswalker you control has the loyalty abilities of {this}";
    }

    private KasminaEnigmaSageGainAbilitiesEffect(KasminaEnigmaSageGainAbilitiesEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm = source.getSourcePermanentIfItStillExists(game);
        if (perm == null) {
            return true;
        }
        List loyaltyAbilities = perm.getAbilities(game).stream().filter(LoyaltyAbility.class::isInstance).collect(Collectors.toList());
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_PLANESWALKER, source.getControllerId(), source, game)) {
            if (permanent == null || permanent == perm) continue;
            for (Ability ability : loyaltyAbilities) {
                permanent.addAbility(ability, source.getSourceId(), game, true);
            }
        }
        return true;
    }

    public KasminaEnigmaSageGainAbilitiesEffect copy() {
        return new KasminaEnigmaSageGainAbilitiesEffect(this);
    }
}

