/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Objects;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class KasminaEnigmaticMentorCostModificationEffect
extends CostModificationEffectImpl {
    KasminaEnigmaticMentorCostModificationEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Spells your opponents cast that target a creature or planeswalker you control cost {2} more to cast";
    }

    private KasminaEnigmaticMentorCostModificationEffect(KasminaEnigmaticMentorCostModificationEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Set allTargets;
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        if (!game.getOpponents(source.getControllerId()).contains(abilityToModify.getControllerId())) {
            return false;
        }
        Spell spell = (Spell)game.getStack().getStackObject(abilityToModify.getId());
        if (spell != null) {
            allTargets = CardUtil.getAllSelectedTargets((Ability)abilityToModify, (Game)game);
        } else {
            allTargets = CardUtil.getAllPossibleTargets((Ability)abilityToModify, (Game)game);
            if (allTargets.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(permanent -> !this.isTargetCompatible((Permanent)permanent, source, game))) {
                return false;
            }
        }
        return allTargets.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(permanent -> this.isTargetCompatible((Permanent)permanent, source, game));
    }

    private boolean isTargetCompatible(Permanent permanent, Ability source, Game game) {
        return permanent.isControlledBy(source.getControllerId()) && (permanent.isCreature(game) || permanent.isPlaneswalker(game));
    }

    public KasminaEnigmaticMentorCostModificationEffect copy() {
        return new KasminaEnigmaticMentorCostModificationEffect(this);
    }
}

