/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class KassandraEagleBearerEffect
extends OneShotEffect {
    private static final String spearName = "The Spear of Leonidas";

    KassandraEagleBearerEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "search your graveyard, hand and/or library for a card named The Spear of Leonidas, put it onto the battlefield, then shuffle.";
    }

    private KassandraEagleBearerEffect(KassandraEagleBearerEffect effect) {
        super((OneShotEffect)effect);
    }

    public KassandraEagleBearerEffect copy() {
        return new KassandraEagleBearerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card spearCard = null;
        FilterCard filter = new FilterCard("card named The Spear of Leonidas");
        filter.add((Predicate)new NamePredicate(spearName));
        TargetCardInLibrary libraryTarget = new TargetCardInLibrary(filter);
        if (controller.searchLibrary(libraryTarget, source, game)) {
            for (UUID id : libraryTarget.getTargets()) {
                spearCard = game.getCard(id);
            }
        }
        if (spearCard == null) {
            TargetCard target;
            FilterCard filter2 = new FilterCard("card from your hand named The Spear of Leonidas");
            filter2.add((Predicate)new NamePredicate(spearName));
            CardsImpl spears = new CardsImpl();
            spears.addAllCards((Collection)controller.getHand().getCards(filter, source.getControllerId(), source, game));
            Set spearsInGraveyard = controller.getGraveyard().getCards(filter, source.getControllerId(), source, game);
            if (spearsInGraveyard.isEmpty()) {
                target = new TargetCard(0, 1, Zone.HAND, filter);
            } else {
                spears.addAllCards((Collection)spearsInGraveyard);
                target = new TargetCard(1, 1, Zone.HAND, filter);
            }
            target.withNotTarget(true);
            if (!spears.isEmpty()) {
                controller.choose(this.outcome, (Cards)spears, target, source, game);
                for (UUID id : target.getTargets()) {
                    spearCard = game.getCard(id);
                }
            }
        }
        if (spearCard != null) {
            controller.moveCards(spearCard, Zone.BATTLEFIELD, source, game);
        }
        controller.shuffleLibrary(source, game);
        return true;
    }
}

