/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class KatabaticWindsRuleModifyingEffect
extends ContinuousRuleModifyingEffectImpl {
    KatabaticWindsRuleModifyingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = ", and their activated abilities with {T} in their costs can't be activated";
    }

    private KatabaticWindsRuleModifyingEffect(KatabaticWindsRuleModifyingEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public KatabaticWindsRuleModifyingEffect copy() {
        return new KatabaticWindsRuleModifyingEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        Optional ability = game.getAbility(event.getTargetId(), event.getSourceId());
        return ability.isPresent() && object != null && object.isCreature(game) && object.getAbilities().contains((Ability)FlyingAbility.getInstance()) && game.getState().getPlayersInRange(source.getControllerId(), game).contains((Object)event.getPlayerId()) && ((Ability)ability.get()).hasTapCost();
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        return "Creatures with flying can't use their activated abilities that use {tap} in their costs.";
    }
}

