/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.ComparisonType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KederektParasiteTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent();

    KederektParasiteTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(1, true, "opponent"), true);
    }

    private KederektParasiteTriggeredAbility(KederektParasiteTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public KederektParasiteTriggeredAbility copy() {
        return new KederektParasiteTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD;
    }

    public boolean checkInterveningIfClause(Game game) {
        return new PermanentsOnTheBattlefieldCondition((FilterPermanent)filter, ComparisonType.MORE_THAN, 0).apply(game, (Ability)this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent draws a card, if you control a red permanent, you may have {this} deal 1 damage to that player.";
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.RED));
    }
}

