/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.k.KeenEaredSentryWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class KeenEaredSentryEffect
extends ContinuousRuleModifyingEffectImpl {
    KeenEaredSentryEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "each opponent can't venture into the dungeon more than once each turn";
    }

    private KeenEaredSentryEffect(KeenEaredSentryEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public KeenEaredSentryEffect copy() {
        return new KeenEaredSentryEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.VENTURE;
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject == null) {
            return null;
        }
        return "You can't venture into the dungeon more than once each turn. (" + sourceObject.getName() + ')';
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getOpponents(source.getControllerId()).contains(event.getTargetId()) && KeenEaredSentryWatcher.checkPlayer(event.getTargetId(), game);
    }
}

