/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandChosenControlledPermanentEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class KefnetTheMindfulEffect
extends OneShotEffect {
    KefnetTheMindfulEffect() {
        super(Outcome.Benefit);
        this.staticText = "Draw a card, then you may return a land you control to its owner's hand";
    }

    private KefnetTheMindfulEffect(KefnetTheMindfulEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        FilterControlledPermanent filterControlledLand = new FilterControlledPermanent("land you control");
        filterControlledLand.add((Predicate)CardType.LAND.getPredicate());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.drawCards(1, source, game);
            if (controller.chooseUse(Outcome.AIDontUseIt, "Return a land you control to its owner's hand?", source, game)) {
                ReturnToHandChosenControlledPermanentEffect effect = new ReturnToHandChosenControlledPermanentEffect(filterControlledLand);
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }

    public KefnetTheMindfulEffect copy() {
        return new KefnetTheMindfulEffect(this);
    }
}

