/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class KellanInquisitiveProdigyEffect
extends OneShotEffect {
    KellanInquisitiveProdigyEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy up to one target artifact. If you controlled that permanent, draw a card";
    }

    private KellanInquisitiveProdigyEffect(KellanInquisitiveProdigyEffect effect) {
        super((OneShotEffect)effect);
    }

    public KellanInquisitiveProdigyEffect copy() {
        return new KellanInquisitiveProdigyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || permanent == null) {
            return false;
        }
        boolean isMine = permanent.isControlledBy(source.getControllerId());
        permanent.destroy(source, game, false);
        if (isMine) {
            controller.drawCards(1, source, game);
        }
        return true;
    }
}

