/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.common.DealsCombatDamageToAPlayerTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTopXMayPlayUntilEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KellanPlanarTrailblazerDetectiveEffect
extends OneShotEffect {
    KellanPlanarTrailblazerDetectiveEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is a Scout, it becomes a Human Faerie Detective and gains \"Whenever {this} deals combat damage to a player, exile the top card of your library. You may play that card this turn.\"";
    }

    private KellanPlanarTrailblazerDetectiveEffect(KellanPlanarTrailblazerDetectiveEffect effect) {
        super((OneShotEffect)effect);
    }

    public KellanPlanarTrailblazerDetectiveEffect copy() {
        return new KellanPlanarTrailblazerDetectiveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.hasSubtype(SubType.SCOUT, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.Custom, new SubType[]{SubType.HUMAN, SubType.FAERIE, SubType.DETECTIVE}), source);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)new DealsCombatDamageToAPlayerTriggeredAbility((Effect)new ExileTopXMayPlayUntilEffect(1, Duration.EndOfTurn).withTextOptions("that card", true)), Duration.Custom), source);
        return true;
    }
}

