/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.k.KessDissidentMageWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;

class KessDissidentMageCastFromGraveyardEffect
extends AsThoughEffectImpl {
    KessDissidentMageCastFromGraveyardEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "During each of your turns, you may cast an instant or sorcery card from your graveyard";
    }

    private KessDissidentMageCastFromGraveyardEffect(KessDissidentMageCastFromGraveyardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public KessDissidentMageCastFromGraveyardEffect copy() {
        return new KessDissidentMageCastFromGraveyardEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        throw new IllegalArgumentException("Wrong code usage: can't call applies method on empty affectedAbility");
    }

    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        if (!playerId.equals(source.getControllerId()) || !game.isActivePlayer(source.getControllerId())) {
            return false;
        }
        if (!playerId.equals(source.getControllerId()) || !game.isActivePlayer(source.getControllerId())) {
            return false;
        }
        Card card = game.getCard(objectId);
        if (card == null || !game.getState().getZone(card.getMainCard().getId()).equals((Object)Zone.GRAVEYARD) || !card.isOwnedBy(source.getControllerId())) {
            return false;
        }
        SpellAbility spell = (SpellAbility)affectedAbility;
        if (spell == null || spell.getManaCosts().isEmpty()) {
            return false;
        }
        Card cardToCheck = spell.getCharacteristics(game);
        if (!cardToCheck.isInstantOrSorcery(game)) {
            return false;
        }
        KessDissidentMageWatcher watcher = (KessDissidentMageWatcher)game.getState().getWatcher(KessDissidentMageWatcher.class);
        return watcher != null && !watcher.isAbilityUsed(new MageObjectReference(source.getSourceId(), game));
    }
}

