/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PreventionEffectImpl;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KharnTheBetrayerPreventionEffect
extends PreventionEffectImpl {
    KharnTheBetrayerPreventionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "if damage would be dealt to {this}, prevent that damage and an opponent of your choice gains control of it";
    }

    private KharnTheBetrayerPreventionEffect(KharnTheBetrayerPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public KharnTheBetrayerPreventionEffect copy() {
        return new KharnTheBetrayerPreventionEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || this.preventDamageAction(event, source, game).getPreventedDamage() == 0) {
            return false;
        }
        TargetOpponent target = new TargetOpponent();
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, true, target.getFirstTarget());
        effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)effect, false, "an opponent of your choice gains control of it.");
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(source.getSourceId());
    }
}

