/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class KianneDeanOfSubstanceExileEffect
extends OneShotEffect {
    KianneDeanOfSubstanceExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top card of your library. If it's a land card, put it into your hand. Otherwise, put a study counter on it.";
    }

    private KianneDeanOfSubstanceExileEffect(KianneDeanOfSubstanceExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public KianneDeanOfSubstanceExileEffect copy() {
        return new KianneDeanOfSubstanceExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (card.isLand(game)) {
            return player.moveCards(card, Zone.HAND, source, game);
        }
        return card.getMainCard().addCounters(CounterType.STUDY.createInstance(), player.getId(), source, game);
    }
}

