/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class KillingWaveEffect
extends OneShotEffect {
    KillingWaveEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "For each creature, its controller sacrifices it unless they pay X life";
    }

    private KillingWaveEffect(KillingWaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public KillingWaveEffect copy() {
        return new KillingWaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int amount = GetXValue.instance.calculate(game, source, (Effect)this);
        if (amount > 0) {
            LinkedList<Permanent> sacrifices = new LinkedList<Permanent>();
            HashMap<UUID, Integer> lifePaidAmounts = new HashMap<UUID, Integer>();
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                List creatures = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, playerId, game);
                int lifePaid = 0;
                int playerLife = player.getLife();
                for (Permanent creature : creatures) {
                    String message = "Pay " + amount + " life? If you don't, " + creature.getName() + " will be sacrificed.";
                    if (playerLife - amount - lifePaid >= 0 && player.chooseUse(Outcome.Neutral, message, source, game)) {
                        game.informPlayers(player.getLogName() + " pays " + amount + " life. They will not sacrifice " + creature.getName());
                        lifePaid += amount;
                        continue;
                    }
                    game.informPlayers(player.getLogName() + " will sacrifice " + creature.getName());
                    sacrifices.add(creature);
                }
                lifePaidAmounts.put(playerId, lifePaid);
            }
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                int lifePaid = (Integer)lifePaidAmounts.get(playerId);
                if (lifePaid <= 0 || (player = game.getPlayer(playerId)) == null) continue;
                player.loseLife(lifePaid, game, source, false);
            }
            for (Permanent creature : sacrifices) {
                creature.sacrifice(source, game);
            }
        }
        return true;
    }
}

