/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.keyword.ToxicAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;

class KinzuOfTheBleakCovenEffect
extends OneShotEffect {
    KinzuOfTheBleakCovenEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay 2 life and exile it. If you do, create a token that's a copy of that creature, except it's 1/1 and has toxic 1.";
    }

    private KinzuOfTheBleakCovenEffect(KinzuOfTheBleakCovenEffect effect) {
        super((OneShotEffect)effect);
    }

    public KinzuOfTheBleakCovenEffect copy() {
        return new KinzuOfTheBleakCovenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        PayLifeCost cost = new PayLifeCost(2);
        if (!(cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(Outcome.Benefit, "Pay 2 Life and Exile " + card.getName() + "?", source, game) && cost.pay(source, game, source, source.getControllerId(), true))) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        return new CreateTokenCopyTargetEffect().setSavedPermanent((Permanent)new PermanentCard(card, source.getControllerId(), game)).setPermanentModifier(token -> {
            token.setPower(1);
            token.setToughness(1);
            token.addAbility((Ability)new ToxicAbility(1));
        }).apply(game, source);
    }
}

