/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class KioraSovereignOfTheDeepEffect
extends OneShotEffect {
    KioraSovereignOfTheDeepEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top X cards of your library, where X is that spell's mana value. You may cast a spell with mana value less than X from among them without paying its mana cost. Put the rest on the bottom of your library in a random order";
    }

    private KioraSovereignOfTheDeepEffect(KioraSovereignOfTheDeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public KioraSovereignOfTheDeepEffect copy() {
        return new KioraSovereignOfTheDeepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (player == null || spell == null || spell.getManaValue() < 1) {
            return false;
        }
        int xValue = spell.getManaValue();
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, xValue));
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue));
        CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)filter);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

