/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ConjureCardEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.PreventDamageByTargetEffect;
import mage.abilities.effects.common.PreventDamageToTargetEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.permanent.token.KrakenToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class KioraTheTidesFury
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent(SubType.KRAKEN, "Kraken");

    public KioraTheTidesFury(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{3}{U}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.KIORA);
        this.setStartingLoyalty(4);
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new ConjureCardEffect("Kraken Hatchling"), 1);
        this.addAbility((Ability)ability);
        LoyaltyAbility secondAbility = new LoyaltyAbility((Effect)new UntapTargetEffect(), 1);
        secondAbility.addEffect((Effect)new PreventDamageToTargetEffect(Duration.UntilYourNextTurn).setText("Prevent all damage that would be dealt to"));
        secondAbility.addEffect((Effect)new PreventDamageByTargetEffect(Duration.UntilYourNextTurn, false).setText(" and dealt by that permanent until your next turn."));
        secondAbility.addTarget((Target)new TargetPermanent(StaticFilters.FILTER_PERMANENT_CREATURE_OR_LAND));
        this.addAbility((Ability)secondAbility);
        this.addAbility((Ability)new LoyaltyAbility((Effect)new DoIfCostPaid((Effect)new CreateTokenEffect((Token)new KrakenToken()), (Cost)new SacrificeTargetCost(filter)), -3));
    }

    private KioraTheTidesFury(KioraTheTidesFury card) {
        super((CardImpl)card);
    }

    public KioraTheTidesFury copy() {
        return new KioraTheTidesFury(this);
    }
}

