/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class KirinTouchedOrochiCounterEffect
extends OneShotEffect {
    KirinTouchedOrochiCounterEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target noncreature card from a graveyard. When you do, put a +1/+1 counter on target creature you control";
    }

    private KirinTouchedOrochiCounterEffect(KirinTouchedOrochiCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public KirinTouchedOrochiCounterEffect copy() {
        return new KirinTouchedOrochiCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        UUID targetId = source.getFirstTarget();
        Card card = game.getCard(targetId);
        if (controller == null || card == null || game.getState().getZone(targetId) != Zone.GRAVEYARD) {
            return false;
        }
        if (!controller.moveCards(card, Zone.EXILED, source, game)) {
            return false;
        }
        ReflexiveTriggeredAbility reflexiveCounterAbility = new ReflexiveTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), false);
        reflexiveCounterAbility.addTarget((Target)new TargetControlledCreaturePermanent());
        game.fireReflexiveTriggeredAbility(reflexiveCounterAbility, source);
        return true;
    }
}

