/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.SpiritToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class KirinTouchedOrochiTokenEffect
extends OneShotEffect {
    KirinTouchedOrochiTokenEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target creature card from a graveyard. When you do, create a 1/1 colorless Spirit creature token";
    }

    private KirinTouchedOrochiTokenEffect(KirinTouchedOrochiTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public KirinTouchedOrochiTokenEffect copy() {
        return new KirinTouchedOrochiTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        UUID targetId = source.getFirstTarget();
        Card card = game.getCard(targetId);
        if (controller == null || card == null || game.getState().getZone(targetId) != Zone.GRAVEYARD) {
            return false;
        }
        if (!controller.moveCards(card, Zone.EXILED, source, game)) {
            return false;
        }
        ReflexiveTriggeredAbility reflexiveTokenAbility = new ReflexiveTriggeredAbility((Effect)new CreateTokenEffect((Token)new SpiritToken()), false);
        game.fireReflexiveTriggeredAbility(reflexiveTokenAbility, source);
        return true;
    }
}

