/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileUntilSourceLeavesEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KitesailFreebooterExileEffect
extends OneShotEffect {
    KitesailFreebooterExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent reveals their hand. You choose a noncreature, nonland card from it. Exile that card until {this} leaves the battlefield";
    }

    private KitesailFreebooterExileEffect(KitesailFreebooterExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public KitesailFreebooterExileEffect copy() {
        return new KitesailFreebooterExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && opponent != null && sourcePermanent != null) {
            if (!opponent.getHand().isEmpty()) {
                opponent.revealCards(sourcePermanent.getIdName(), opponent.getHand(), game);
                FilterNonlandCard filter = new FilterNonlandCard("noncreature, nonland card to exile");
                filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
                TargetCard target = new TargetCard(Zone.HAND, (FilterCard)filter);
                if (opponent.getHand().count((FilterCard)filter, game) > 0 && controller.choose(Outcome.Exile, opponent.getHand(), target, source, game)) {
                    Card card = opponent.getHand().get(target.getFirstTarget(), game);
                    if (card == null) {
                        return true;
                    }
                    ExileUntilSourceLeavesEffect effect = new ExileUntilSourceLeavesEffect(Zone.HAND);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
                    return effect.apply(game, source);
                }
            }
            return true;
        }
        return false;
    }
}

