/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KithkinArmorRestrictionEffect
extends RestrictionEffect {
    KithkinArmorRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Enchanted creature can't be blocked by creatures with power 3 or greater";
    }

    private KithkinArmorRestrictionEffect(KithkinArmorRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null) {
            Permanent enchantedPermanent = game.getPermanent(enchantment.getAttachedTo());
            return enchantedPermanent != null && permanent.getId().equals(enchantedPermanent.getId());
        }
        return false;
    }

    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return blocker.getPower().getValue() < 3;
    }

    public KithkinArmorRestrictionEffect copy() {
        return new KithkinArmorRestrictionEffect(this);
    }
}

