/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.k.KodamaOfTheEastTreeWatcher;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class KodamaOfTheEastTreeEffect
extends OneShotEffect {
    KodamaOfTheEastTreeEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put a permanent card with equal or lesser mana value from your hand onto the battlefield";
    }

    private KodamaOfTheEastTreeEffect(KodamaOfTheEastTreeEffect effect) {
        super((OneShotEffect)effect);
    }

    public KodamaOfTheEastTreeEffect copy() {
        return new KodamaOfTheEastTreeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object obj = this.getValue("permanentEnteringBattlefield");
        if (!(obj instanceof Permanent)) {
            return false;
        }
        Permanent permanent = (Permanent)obj;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FilterPermanentCard filter = new FilterPermanentCard("a permanent card with mana value " + permanent.getManaValue() + " or less");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, permanent.getManaValue() + 1));
        TargetCardInHand target = new TargetCardInHand((FilterCard)filter);
        if (!target.canChoose(source.getControllerId(), source, game) || !player.chooseUse(this.outcome, "Put a permanent card onto the battlefield?", source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent otherPermanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (otherPermanent == null) {
            return false;
        }
        KodamaOfTheEastTreeWatcher watcher = (KodamaOfTheEastTreeWatcher)game.getState().getWatcher(KodamaOfTheEastTreeWatcher.class);
        if (watcher != null) {
            watcher.addPermanent(otherPermanent, source, game);
        }
        return true;
    }
}

