/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.k.KomainuBattleArmorEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KomainuBattleArmorTriggeredAbility
extends TriggeredAbilityImpl {
    KomainuBattleArmorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new KomainuBattleArmorEffect());
    }

    private KomainuBattleArmorTriggeredAbility(KomainuBattleArmorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public KomainuBattleArmorTriggeredAbility copy() {
        return new KomainuBattleArmorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        if (this.getSourceId().equals(event.getSourceId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            return true;
        }
        Permanent permanent = this.getSourcePermanentOrLKI(game);
        if (permanent != null && event.getSourceId().equals(permanent.getAttachedTo())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} or equipped creature deals combat damage to a player, goad each creature that player controls.";
    }
}

