/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.SubType;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum KoseiPenitentWarlordCondition implements Condition
{
    instance;


    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent == null) return false;
        if (!sourcePermanent.getCounters(game).values().stream().mapToInt(Counter::getCount).anyMatch(x -> x > 0)) return false;
        if (!sourcePermanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(permanent -> permanent.hasSubtype(SubType.EQUIPMENT, game))) return false;
        if (!sourcePermanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(permanent -> permanent.hasSubtype(SubType.AURA, game))) return false;
        return true;
    }
}

