/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class KotisTheFangkeeperEffect
extends OneShotEffect {
    KotisTheFangkeeperEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top X cards of their library, where X is the amount of damage dealt. You may cast any number of spells with mana value X or less from among them without paying their mana costs";
    }

    private KotisTheFangkeeperEffect(KotisTheFangkeeperEffect effect) {
        super((OneShotEffect)effect);
    }

    public KotisTheFangkeeperEffect copy() {
        return new KotisTheFangkeeperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        int xValue = (Integer)this.getValue("damage");
        if (controller == null || player == null || xValue < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, xValue));
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)filter);
        return true;
    }
}

