/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class KozilekTheBrokenRealityEffect
extends OneShotEffect {
    KozilekTheBrokenRealityEffect() {
        super(Outcome.Neutral);
        this.staticText = "up to two target players each manifest two cards from their hands. For each card manifested this way, you draw a card";
    }

    private KozilekTheBrokenRealityEffect(KozilekTheBrokenRealityEffect effect) {
        super((OneShotEffect)effect);
    }

    public KozilekTheBrokenRealityEffect copy() {
        return new KozilekTheBrokenRealityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        boolean result = false;
        int toDraw = 0;
        for (UUID playerId : this.getTargetPointer().getTargets(game, source)) {
            int amount;
            Player player = game.getPlayer(playerId);
            if (player == null || (amount = Math.min(2, player.getHand().size())) <= 0) continue;
            TargetCardInHand target = new TargetCardInHand(amount, StaticFilters.FILTER_CARD).withChooseHint("to manifest");
            target.choose(Outcome.Discard, playerId, source.getId(), source, game);
            CardsImpl toManifest = new CardsImpl((Collection)target.getTargets());
            toDraw += ManifestEffect.doManifestCards((Game)game, (Ability)source, (Player)player, (Set)toManifest.getCards(game)).size();
            result = true;
        }
        if (toDraw > 0) {
            controller.drawCards(toDraw, source, game);
        }
        return result;
    }
}

