/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.AttackedThisTurnPredicate;
import mage.game.Game;
import mage.players.Player;

class KratosGodOfWarEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    KratosGodOfWarEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage to that player equal to the number of creatures that player controls that didn't attack this turn.";
    }

    private KratosGodOfWarEffect(KratosGodOfWarEffect effect) {
        super((OneShotEffect)effect);
    }

    public KratosGodOfWarEffect copy() {
        return new KratosGodOfWarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        int count = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        return count > 0 && player.damage(count, source, game) > 0;
    }

    static {
        filter.add(Predicates.not((Predicate)AttackedThisTurnPredicate.instance));
    }
}

