/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInLibrary;

class KrenkosBuzzcrusherEffect
extends OneShotEffect {
    KrenkosBuzzcrusherEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "for each player, destroy up to one nonbasic land that player controls. For each land destroyed this way, its controller may search their library for a basic land card, put it onto the battlefield tapped, then shuffle";
    }

    private KrenkosBuzzcrusherEffect(KrenkosBuzzcrusherEffect effect) {
        super((OneShotEffect)effect);
    }

    public KrenkosBuzzcrusherEffect copy() {
        return new KrenkosBuzzcrusherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInLibrary target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<Permanent> chosenLands = new ArrayList<Permanent>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            FilterLandPermanent filter = new FilterLandPermanent("nonbasic land " + player.getName() + " controls");
            filter.add((Predicate)new ControllerIdPredicate(playerId));
            filter.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
            target = new TargetPermanent(0, 1, (FilterPermanent)filter);
            target.withNotTarget(true);
            controller.chooseTarget(this.outcome, (Target)target, source, game);
            Permanent land = game.getPermanent(target.getFirstTarget());
            if (land == null) continue;
            chosenLands.add(land);
        }
        ArrayList<Permanent> destroyedLands = new ArrayList<Permanent>();
        for (Permanent land : chosenLands) {
            if (!land.destroy(source, game)) continue;
            destroyedLands.add(land);
        }
        for (Permanent land : destroyedLands) {
            Player player = game.getPlayer(land.getControllerId());
            if (player == null) continue;
            target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND_A);
            if (!player.chooseUse(Outcome.PutLandInPlay, "Search your library for " + target.getDescription() + "?", source, game) || !player.searchLibrary(target, source, game)) continue;
            player.moveCards(game.getCard(target.getFirstTarget()), Zone.BATTLEFIELD, source, game, true, false, false, null);
            player.shuffleLibrary(source, game);
        }
        return true;
    }
}

