/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextUpkeepDelayedTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapAttachedCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.counter.AddCountersAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetAnyTarget;

public final class KrovikanPlague
extends CardImpl {
    private static final FilterPermanent filterNonWall = new FilterControlledCreaturePermanent("non-Wall creature you control");
    private static final FilterPermanent filter;
    private static final Condition condition;

    public KrovikanPlague(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{B}");
        this.subtype.add((Object)SubType.AURA);
        TargetPermanent auraTarget = new TargetPermanent(filterNonWall);
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        this.addAbility((Ability)new EntersBattlefieldTriggeredAbility((Effect)new CreateDelayedTriggeredAbilityEffect((DelayedTriggeredAbility)new AtTheBeginOfNextUpkeepDelayedTriggeredAbility((Effect)new DrawCardSourceControllerEffect(1), Duration.OneUse)).setText("draw a card at the beginning of the next turn's upkeep"), false));
        ActivateIfConditionActivatedAbility ability = new ActivateIfConditionActivatedAbility((Effect)new DamageTargetEffect(1), (Cost)new TapAttachedCost(), condition);
        ability.addEffect((Effect)new AddCountersAttachedEffect(CounterType.M0M1.createInstance(), "enchanted creature"));
        ability.addTarget((Target)new TargetAnyTarget());
        this.addAbility((Ability)ability);
    }

    private KrovikanPlague(KrovikanPlague card) {
        super((CardImpl)card);
    }

    public KrovikanPlague copy() {
        return new KrovikanPlague(this);
    }

    static {
        filterNonWall.add(Predicates.not((Predicate)SubType.WALL.getPredicate()));
        filter = new FilterCreaturePermanent("enchanted creature is untapped");
        filter.add((Predicate)TappedPredicate.UNTAPPED);
        condition = new AttachedToMatchesFilterCondition(filter);
    }
}

