/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class KrovikanVampireCreaturesDamagedWatcher
extends Watcher {
    private final Set<UUID> damagedBySource = new HashSet<UUID>();

    public KrovikanVampireCreaturesDamagedWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PERMANENT || !this.sourceId.equals(event.getSourceId())) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null || !permanent.isCreature(game)) {
            return;
        }
        this.damagedBySource.add(event.getTargetId());
    }

    public Set<UUID> getDamagedBySource() {
        return this.damagedBySource;
    }

    public void reset() {
        this.damagedBySource.clear();
    }
}

