/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class KrovikanVampireCreaturesDiedWatcher
extends Watcher {
    private final Set<UUID> diedThisTurn = new HashSet<UUID>();

    public KrovikanVampireCreaturesDiedWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && (zEvent = (ZoneChangeEvent)event).isDiesEvent() && zEvent.getTarget() != null && zEvent.getTarget().isCreature(game)) {
            this.diedThisTurn.add(zEvent.getTargetId());
        }
    }

    public void reset() {
        this.diedThisTurn.clear();
    }

    public Set<UUID> getDiedThisTurn() {
        return this.diedThisTurn;
    }
}

