/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.TargetController;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KulrathKnightRestrictionEffect
extends RestrictionEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures your opponents control with counters on them");

    public KulrathKnightRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures your opponents control with counters on them can't attack or block.";
    }

    private KulrathKnightRestrictionEffect(KulrathKnightRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public KulrathKnightRestrictionEffect copy() {
        return new KulrathKnightRestrictionEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return filter.match(permanent, source.getControllerId(), source, game);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

