/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KusariGamaDamageEffect
extends OneShotEffect {
    KusariGamaDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals that much damage to each other creature defending player controls";
    }

    private KusariGamaDamageEffect(KusariGamaDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public KusariGamaDamageEffect copy() {
        return new KusariGamaDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Integer damage = (Integer)this.getValue("damageAmount");
        if (damage != null && damage > 0) {
            UUID damagedCreatureId = (UUID)this.getValue("damagedCreatureId");
            Permanent creature = game.getPermanent(damagedCreatureId);
            if (creature == null) {
                creature = (Permanent)game.getLastKnownInformation(damagedCreatureId, Zone.BATTLEFIELD);
            }
            if (creature != null) {
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, creature.getControllerId(), game)) {
                    if (permanent.getId().equals(damagedCreatureId)) continue;
                    permanent.damage(damage.intValue(), source.getSourceId(), source, game, false, true);
                }
            }
            return true;
        }
        return false;
    }
}

