/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

class KyloxVisionaryInventorEffect
extends OneShotEffect {
    KyloxVisionaryInventorEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice any number of other creatures, then exile the top X cards of your library, where X is their total power. You may cast any number of instant and/or sorcery spells from among the exiled cards without paying their mana costs";
    }

    private KyloxVisionaryInventorEffect(KyloxVisionaryInventorEffect effect) {
        super((OneShotEffect)effect);
    }

    public KyloxVisionaryInventorEffect copy() {
        return new KyloxVisionaryInventorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_OTHER_CONTROLLED_CREATURES);
        player.choose(this.outcome, (Target)target, source, game);
        Set permanents = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        int xValue = permanents.stream().map(MageObject::getPower).mapToInt(MageInt::getValue).sum();
        for (Permanent permanent : permanents) {
            permanent.sacrifice(source, game);
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, xValue));
        if (cards.isEmpty()) {
            return true;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        CardUtil.castMultipleWithAttributeForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
        return true;
    }
}

