/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

class KyloxsVoltstriderReplacementEffect
extends ReplacementEffectImpl {
    KyloxsVoltstriderReplacementEffect() {
        super(Duration.Custom, Outcome.Exile);
        this.staticText = "If that spell would be put into a graveyard, put it on the bottom of its owner's library instead.";
    }

    private KyloxsVoltstriderReplacementEffect(KyloxsVoltstriderReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public KyloxsVoltstriderReplacementEffect copy() {
        return new KyloxsVoltstriderReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getToZone() == Zone.GRAVEYARD && event.getTargetId().equals(((FixedTarget)this.getTargetPointer()).getTarget()) && ((FixedTarget)this.getTargetPointer()).getZoneChangeCounter() == game.getState().getZoneChangeCounter(zEvent.getTargetId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null || controller == null) {
            return false;
        }
        controller.putCardsOnBottomOfLibrary(card, game, source);
        return true;
    }
}

