/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class LoseGainEffect
extends OneShotEffect {
    LoseGainEffect() {
        super(Outcome.Benefit);
        this.staticText = "target player loses 2 life and you gain 2 life";
    }

    private LoseGainEffect(LoseGainEffect effect) {
        super((OneShotEffect)effect);
    }

    public LoseGainEffect copy() {
        return new LoseGainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Player them = game.getPlayer(source.getFirstTarget());
        if (you == null && them == null) {
            return false;
        }
        if (you != null) {
            you.gainLife(2, game, source);
        }
        if (them != null) {
            them.loseLife(2, game, source, false);
        }
        return true;
    }
}

