/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.AnyColorManaAbility;
import mage.abilities.mana.ColorlessManaAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubTypeSet;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ChangeLandAttachedEffect
extends ContinuousEffectImpl {
    ChangeLandAttachedEffect() {
        super(Duration.WhileOnBattlefield, Outcome.AddAbility);
        this.staticText = "Enchanted land loses all land types and abilities and has \"{T}: Add {C}\" and \"{T}, Pay 1 life: Add one mana of any color.\"";
    }

    private ChangeLandAttachedEffect(ChangeLandAttachedEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ChangeLandAttachedEffect copy() {
        return new ChangeLandAttachedEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(enchantment.getAttachedTo());
        if (permanent == null) {
            return true;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.removeAllAbilities(source.getSourceId(), game);
                permanent.addAbility((Ability)new ColorlessManaAbility(), source.getSourceId(), game);
                AnyColorManaAbility ability = new AnyColorManaAbility();
                ability.addCost((Cost)new PayLifeCost(1));
                permanent.addAbility((Ability)ability, source.getSourceId(), game);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.TypeChangingEffects_4;
    }
}

