/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeBatchEvent;
import mage.game.events.ZoneChangeEvent;

class LaeliaTheBladeReforgedAddCountersTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<ZoneChangeEvent> {
    LaeliaTheBladeReforgedAddCountersTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()), false);
    }

    private LaeliaTheBladeReforgedAddCountersTriggeredAbility(LaeliaTheBladeReforgedAddCountersTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LaeliaTheBladeReforgedAddCountersTriggeredAbility copy() {
        return new LaeliaTheBladeReforgedAddCountersTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_BATCH;
    }

    public boolean checkEvent(ZoneChangeEvent event, Game game) {
        if (event.getToZone() != Zone.EXILED) {
            return false;
        }
        if (event.getFromZone() != Zone.LIBRARY && event.getFromZone() != Zone.GRAVEYARD) {
            return false;
        }
        Card card = game.getCard(event.getTargetId());
        return card != null && card.isOwnedBy(this.getControllerId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return !this.getFilteredEvents((BatchEvent)((ZoneChangeBatchEvent)event), game).isEmpty();
    }

    public String getRule() {
        return "Whenever one or more cards are put into exile from your library and/or your graveyard, put a +1/+1 counter on {this}.";
    }
}

