/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LandEquilibriumAbility
extends TriggeredAbilityImpl {
    public LandEquilibriumAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SacrificeEffect((FilterPermanent)StaticFilters.FILTER_LAND, 1, ""), false);
    }

    private LandEquilibriumAbility(LandEquilibriumAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LandEquilibriumAbility copy() {
        return new LandEquilibriumAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LAND_PLAYED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int theirLands;
        int numMyLands = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_LAND, this.getControllerId(), game);
        if (numMyLands < (theirLands = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_LAND, event.getPlayerId(), game))) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "If an opponent who controls at least as many lands as you do would put a land onto the battlefield, that player instead puts that land onto the battlefield then sacrifices a land";
    }
}

