/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class LandslideEffect
extends OneShotEffect {
    static final FilterPermanent filter = new FilterPermanent("Mountains to sacrifice");

    public LandslideEffect() {
        super(Outcome.Benefit);
        this.staticText = "Sacrifice any number of Mountains. {this} deals that much damage to target player or planeswalker";
    }

    private LandslideEffect(LandslideEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        if (you != null) {
            TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
            if (!target.canChoose(source.getControllerId(), source, game)) {
                return false;
            }
            you.chooseTarget(Outcome.Detriment, (Target)target, source, game);
            if (!target.getTargets().isEmpty()) {
                int amount = 0;
                for (UUID targetId : target.getTargets()) {
                    Permanent permanent = game.getPermanent(targetId);
                    if (permanent == null || !permanent.sacrifice(source, game)) continue;
                    ++amount;
                }
                Player player = game.getPlayer(source.getFirstTarget());
                if (player != null) {
                    player.damage(amount, source.getSourceId(), source, game);
                }
            }
            return true;
        }
        return false;
    }

    public LandslideEffect copy() {
        return new LandslideEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((Predicate)SubType.MOUNTAIN.getPredicate());
    }
}

