/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class LanternOfTheLostEffect
extends OneShotEffect {
    LanternOfTheLostEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all cards from all graveyards, then draw a card";
    }

    private LanternOfTheLostEffect(LanternOfTheLostEffect effect) {
        super((OneShotEffect)effect);
    }

    public LanternOfTheLostEffect copy() {
        return new LanternOfTheLostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).forEach(arg_0 -> ((Cards)cards).addAll(arg_0));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        player.drawCards(1, source, game);
        return true;
    }
}

